import tkinter as tk
from tkinter import filedialog
import tabula
import pandas as pd
from tkinter import ttk
import pdfplumber

class PDFTableExtractorApp:
    def __init__(self, root):
        self.root = root
        self.root.title("PDF Table Extractor")
        root.geometry('500x500')
        self.pdf_file_path = None
        self.data_frame = None

        self.create_widgets()

    def create_widgets(self):
        # File Selection
        self.file_label = tk.Label(self.root, text="Selected file: No file selected")
        self.file_label.pack(pady=10)

        open_button = tk.Button(self.root, text="Open PDF File", command=self.open_pdf_dialog)
        open_button.pack(pady=10)

        

        # Extract Tables and Build DataFrame
        #extract_button = tk.Button(self.root, text="Extract Tables and Build DataFrame", command=self.extract_tables_and_build_dataframe)
        #extract_button.pack(pady=10)

        # Combo Box for First Column Data
        self.column_data_label = tk.Label(self.root, text="Select Register Number of the Student:")
        self.column_data_label.pack(pady=5)

        self.column_data_combo = ttk.Combobox(self.root, state="readonly")
        
        self.column_data_combo.pack(pady=10)
        self.stud_label = tk.Label(self.root, text="Selected Student: No student selected",font=("Helvetica", 14))
        self.stud_label.pack(pady=10)
        
        self.l_sub1 = tk.Label(self.root, text=" ",font=("Helvetica", 12))
        self.l_sub1.pack(pady=5,anchor="w")
        self.l_sub2 = tk.Label(self.root, text=" ",font=("Helvetica", 12))
        self.l_sub2.pack(pady=5,anchor="w")
        self.l_sub3 = tk.Label(self.root, text=" ",font=("Helvetica", 12))
        self.l_sub3.pack(pady=5,anchor="w")
        self.l_sub4 = tk.Label(self.root, text=" ",font=("Helvetica", 12))
        self.l_sub4.pack(pady=5,anchor="w")
        self.l_sub5 = tk.Label(self.root, text=" ",font=("Helvetica", 12))
        self.l_sub5.pack(pady=5,anchor="w")
        self.l_sub6 = tk.Label(self.root, text=" ",font=("Helvetica", 12))
        self.l_sub6.pack(pady=5,anchor="w")
        self.l_sub7 = tk.Label(self.root, text=" ",font=("Helvetica", 12))
        self.l_sub7.pack(pady=5,anchor="w")
        self.l_sub8 = tk.Label(self.root, text=" ",font=("Helvetica", 12))
        self.l_sub8.pack(pady=5,anchor="w")
        self.l_sgpa = tk.Label(self.root, text=" ",font=("Helvetica", 14))
        self.l_sgpa.pack(pady=5,anchor="w")       

    def open_pdf_dialog(self):
        file_path = filedialog.askopenfilename(filetypes=[("PDF files", "*.pdf")])
        if file_path:
            self.pdf_file_path = file_path
            self.file_label.config(text=f"Selected file: {file_path}")
            self.extract_tables_and_build_dataframe()

            
    def on_combobox_select(self,event):
     selected_item = self.column_data_combo.get()
     #print(f"Selected item: {selected_item}")
     df = pd.read_csv("result.csv")
     select_stud = df.loc[df['Register No'] == selected_item]
     sel_list=select_stud.values.flatten().tolist()
     
     df = pd.read_csv("stud_reg_name.csv")
     select_name = df.loc[df['Register No'] == selected_item]
     sel_list_name=select_name.values.flatten().tolist()
     self.stud_label.config(text=f"Student Name: {sel_list_name[1]}")

     
     res_list=sel_list[2].split(", ")
     sub=[]
     grade=[]
     grade1=[]
     for i in res_list:
      sub.append(i[:6])
      grade.append(i[7:9])
     #print(sub)
     #print(grade)

     
     for idx, ele in enumerate(grade):
       grade[idx] = ele.replace(')', '')
     print(grade)
     sub_name1=[]
     tot_cred=[]
     df=pd.read_csv('sub_credit1.csv')
     for i in sub:
      sub_name = df.loc[df['code'] == i]
      sub_name1.append(sub_name.values.flatten().tolist()[1])
      tot_cred.append(sub_name.values.flatten().tolist()[2])
     #print(sub_name1)
     comb= sub_name1[0]+" - "+grade[0]
     self.l_sub1.config(text=f"{comb}")
     comb= sub_name1[1]+" - "+grade[1]
     self.l_sub2.config(text=f"{comb}")
     comb= sub_name1[2]+" - "+grade[2]
     self.l_sub3.config(text=f"{comb}")
     comb= sub_name1[3]+" - "+grade[3]
     self.l_sub4.config(text=f"{comb}")
     comb= sub_name1[4]+" - "+grade[4]
     self.l_sub5.config(text=f"{comb}")
     if len(sub_name1)>=6:
      comb= sub_name1[5]+" - "+grade[5]   
      self.l_sub6.config(text=f"{comb}")
     if len(sub_name1)>=7:
      comb= sub_name1[6]+" - "+grade[6]  
      self.l_sub7.config(text=f"{comb}")
     if len(sub_name1)>=8:
      comb= sub_name1[7]+" - "+grade[7]
      self.l_sub8.config(text=f"{comb}")
     sgpa=[]
     df = pd.read_csv("grade_point.csv")
     for i in grade:
      if str(i)=='S':
          sgpa.append(10)
      elif str(i)=='A+':
          sgpa.append(9)
      elif str(i)=='A':
          sgpa.append(8.5)
      elif str(i)=='B+':
          sgpa.append(8)
      elif str(i)=='B':
          sgpa.append(7.5)
      elif str(i)=='C+':
          sgpa.append(7)
      elif str(i)=='C':
          sgpa.append(6.5)
      elif str(i)=='D':
          sgpa.append(6)
      elif str(i)=='P':
          sgpa.append(5.5)
      else:
          sgpa.append(0)
     #print(sgpa)
     #print(tot_cred)
     tot=map(int,tot_cred)
     #print(tot_cred)
     tot1=sum(tot)
     print(tot1)
     sg=0
     for x,y in zip(sgpa,tot_cred):
      sg=sg+(x*int(y))
     finalsg=sg/tot1
     print(finalsg)
     status="Passed"
     for i in sgpa:
      if i==0:
       status="Failed"
     sta=status+"  "+ str(finalsg) 
     self.l_sub8.config(text=f"{sta}")
      
     
    def extract_tables_and_build_dataframe(self):
        print(self.pdf_file_path)
        pdf = pdfplumber.open(self.pdf_file_path)
        newtab=[]
        print(len(pdf.pages))
        for i in range(0,len(pdf.pages)-1):
         p0 = pdf.pages[i]
         table =p0.extract_table()
         newtab=newtab+table
        print(newtab)
        #df = pd.DataFrame(table[1:], columns=table[0])
        df=pd.DataFrame(newtab)
        #print(df[:,:])
        headerList = ['Register No', 'Course Code (Grade)'] 
        df.to_csv("result.csv",header=headerList)
        #with pd.ExcelWriter("path_to_file.xlsx") as writer:
         #df.to_excel(writer, header=False)
        df = pd.read_csv("result.csv")
        reg_no = df.iloc[:, 1].tolist()
        reg_no = [item for item in reg_no if item != 'Register No']
        self.column_data_combo['values']=reg_no
        selected_reg = tk.StringVar()
        self.column_data_combo.bind('<<ComboboxSelected>>', self.on_combobox_select)
   
       
        
        
        
    
    

if __name__ == "__main__":
    root = tk.Tk()
    app = PDFTableExtractorApp(root)
    root.mainloop()
